using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using UnityEngine;
using hive;
using MiniJSON;

public class HivePostProcessSettingIOS
{
    private HivePostProcessDefaultSettingIOS defaultSetting;
    private HivePostProcessKey postProcessKey;
    private HivePostProcessFileIOS file;
    // Capabilites
    public bool isAddPushNotifications;
    public bool isPushNotificationsDevelopment;
    public bool hasPushNotificationMediaContents;
    public bool hasPushNotificationActionButtons;

    public List<string> pushNotificatonActionButtonCategories;
    public bool isAddBackGroundModesRemoteNotifications;
    public bool isAddSignInWithApple;
    public bool isAddGameCenter;
    public bool isAddAgeRange;

    public bool isAddInAppPurchase;
    public bool isAddAssociatedDomains;
    public List<string> associatedDomains;
    /*// Info.plist
    public bool isAddGoogleServiceInfoPlist;
    public string googleServiceInfoPlistFilePath;
    */

    public HivePostProcessSettingIOS() {
        defaultSetting = new HivePostProcessDefaultSettingIOS();
        postProcessKey = new HivePostProcessKey();
        file = new HivePostProcessFileIOS();

        load();
    }

    public string toJsonString() {
        var dictionary = this.toDictionary();
        var jsonObj = new hive.JSONObject(dictionary);
        var jsonString = jsonObj.ToString();

        return jsonString;
    }

    public Dictionary<string, string> toDictionary() {
        var dictionary = new Dictionary<string, string>();
        dictionary[postProcessKey.isAddPushNotifications] = this.isAddPushNotifications.ToString();
        dictionary[postProcessKey.isPushNotificationsDevelopment] = this.isPushNotificationsDevelopment.ToString();
        dictionary[postProcessKey.hasPushNotificationMediaContents] = this.hasPushNotificationMediaContents.ToString();
        dictionary[postProcessKey.hasPushNotificationActionButtons] = this.hasPushNotificationActionButtons.ToString();
        dictionary[postProcessKey.pushNotificatonActionButtonCategories] = this.pushNotificatonActionButtonCategories.ToString();
        dictionary[postProcessKey.isAddBackGroundModesRemoteNotifications] = this.isAddBackGroundModesRemoteNotifications.ToString();
        dictionary[postProcessKey.isAddSignInWithApple] = this.isAddSignInWithApple.ToString();
        dictionary[postProcessKey.isAddGameCenter] = this.isAddGameCenter.ToString();
        dictionary[postProcessKey.isAddAgeRange] = this.isAddAgeRange.ToString();
        dictionary[postProcessKey.isAddInAppPurchase] = this.isAddInAppPurchase.ToString();
        dictionary[postProcessKey.isAddAssociatedDomains] = this.isAddAssociatedDomains.ToString();
        var associatedDomainsString = Json.Serialize(this.associatedDomains);
        dictionary[postProcessKey.associatedDomains] = associatedDomainsString;
        /*
        dictionary[postProcessKey.isAddGoogleServiceInfoPlist] = this.isAddGoogleServiceInfoPlist.ToString();
        dictionary[postProcessKey.googleServiceInfoPlistFilePath] = this.googleServiceInfoPlistFilePath.ToString();
        */

        return dictionary;
    }

    public void reset() {
        HiveLogger.Log("HivePostProcessSettingIOS - reset.");

        isAddPushNotifications = defaultSetting.isAddPushNotifications;
        isPushNotificationsDevelopment = defaultSetting.isPushNotificationsDevelopment;
        hasPushNotificationMediaContents = defaultSetting.hasPushNotificationMediaContents;
        hasPushNotificationActionButtons = defaultSetting.hasPushNotificationActionButtons;
        pushNotificatonActionButtonCategories = defaultSetting.pushNotificatonActionButtonCategories;
        isAddBackGroundModesRemoteNotifications = defaultSetting.isAddBackGroundModesRemoteNotifications;
        isAddSignInWithApple = defaultSetting.isAddSignInWithApple;
        isAddGameCenter = defaultSetting.isAddGameCenter;
        isAddAgeRange = defaultSetting.isAddAgeRange;
        isAddInAppPurchase = defaultSetting.isAddInAppPurchase;
        isAddAssociatedDomains = defaultSetting.isAddAssociatedDomains;
        associatedDomains = defaultSetting.associatedDomains;
        /*
        isAddGoogleServiceInfoPlist = defaultSetting.isAddGoogleServiceInfoPlist;
        googleServiceInfoPlistFilePath = defaultSetting.googleServiceInfoPlistFilePath;
        */
    }

    public void apply() {
        HiveLogger.Log("HivePostProcessSettingIOS - apply.");

        file.writePostProcessSetting(this.toDictionary());
    }

    private void load() {
        HiveLogger.Log("HivePostProcessSettingIOS - load.");

        var dictionary = file.readPostProcessSetting();

        if (dictionary == null) {
            reset();
            return;
        }

        try {
            bool.TryParse(dictionary[postProcessKey.isAddPushNotifications], out isAddPushNotifications);
        } catch {
            HiveLogger.Log("Set isAddPushNotifications as a default value.");
            isAddPushNotifications = defaultSetting.isAddPushNotifications;
        }

        try {
            bool.TryParse(dictionary[postProcessKey.isPushNotificationsDevelopment], out isPushNotificationsDevelopment);
        } catch {
            HiveLogger.Log("Set isPushNotificationsDevelopment as a default value.");
            isPushNotificationsDevelopment = defaultSetting.isPushNotificationsDevelopment;
        }

        try {
            bool.TryParse(dictionary[postProcessKey.hasPushNotificationMediaContents], out hasPushNotificationMediaContents);
        } catch {
            HiveLogger.Log("Set hasPushNotificationMediaContents as a default value.");
            hasPushNotificationMediaContents = defaultSetting.hasPushNotificationMediaContents;
        }

        try {
            bool.TryParse(dictionary[postProcessKey.hasPushNotificationActionButtons], out hasPushNotificationActionButtons);
        } catch {
            HiveLogger.Log("Set hasPushNotificationActionButtons as a default value.");
            hasPushNotificationActionButtons = defaultSetting.hasPushNotificationActionButtons;
        }

        try {
            string pushNotificatonActionButtonCategoriesString = dictionary[postProcessKey.pushNotificatonActionButtonCategories];
            var pushNotificatonActionButtonCategoriesObjList = Json.Deserialize(pushNotificatonActionButtonCategoriesString) as List<object>;
            pushNotificatonActionButtonCategories = pushNotificatonActionButtonCategoriesObjList.Select(obj => (string)obj).ToList();
        } catch {
            HiveLogger.Log("Set associatedDomains as a default value.");
            pushNotificatonActionButtonCategories = defaultSetting.pushNotificatonActionButtonCategories;
        }

        try {
            bool.TryParse(dictionary[postProcessKey.isAddBackGroundModesRemoteNotifications], out isAddBackGroundModesRemoteNotifications);
        } catch {
            HiveLogger.Log("Set isAddBackGroundModesRemoteNotifications as a default value.");
            isAddBackGroundModesRemoteNotifications = defaultSetting.isAddBackGroundModesRemoteNotifications;
        }

        try {
            bool.TryParse(dictionary[postProcessKey.isAddBackGroundModesRemoteNotifications], out isAddBackGroundModesRemoteNotifications);
        } catch {
            HiveLogger.Log("Set isAddBackGroundModesRemoteNotifications as a default value.");
            isAddBackGroundModesRemoteNotifications = defaultSetting.isAddBackGroundModesRemoteNotifications;
        }
        
        try {
            bool.TryParse(dictionary[postProcessKey.isAddSignInWithApple], out isAddSignInWithApple);
        } catch {
            HiveLogger.Log("Set isAddSignInWithApple as a default value.");
            isAddSignInWithApple = defaultSetting.isAddSignInWithApple;
        }

        try
        {
            bool.TryParse(dictionary[postProcessKey.isAddGameCenter], out isAddGameCenter);
        }
        catch
        {
            HiveLogger.Log("Set isAddGameCenter as a default value.");
            isAddGameCenter = defaultSetting.isAddGameCenter;
        }

        try
        {
            bool.TryParse(dictionary[postProcessKey.isAddAgeRange], out isAddAgeRange);
        }
        catch
        {
            HiveLogger.Log("Set isAddAgeRange as a default value.");
            isAddAgeRange = defaultSetting.isAddAgeRange;
        }

        try {
            bool.TryParse(dictionary[postProcessKey.isAddInAppPurchase], out isAddInAppPurchase);
        } catch {
            HiveLogger.Log("Set isAddInAppPurchase as a default value.");
            isAddInAppPurchase = defaultSetting.isAddInAppPurchase;
        }

        try {
            bool.TryParse(dictionary[postProcessKey.isAddAssociatedDomains], out isAddAssociatedDomains);
        } catch {
            HiveLogger.Log("Set isAddAssociatedDomains as a default value.");
            isAddAssociatedDomains = defaultSetting.isAddAssociatedDomains;
        }
        
        try {
            string associatedDomainsString = dictionary[postProcessKey.associatedDomains];
            var associatedDomainsObjList = Json.Deserialize(associatedDomainsString) as List<object>;
            associatedDomains = associatedDomainsObjList.Select(obj => (string)obj).ToList();
        } catch {
            HiveLogger.Log("Set associatedDomains as a default value.");
            associatedDomains = defaultSetting.associatedDomains;
        }

        /*
        googleServiceInfoPlistFilePath = dictionary[postProcessKey.googleServiceInfoPlistFilePath];
        if (string.IsNullOrEmpty(googleServiceInfoPlistFilePath)) {
            HiveLogger.Log("Parse googleServiceInfoPlistFilePath failed.");
        }
        */
    }

}